' Definiuje waciwoci implementowane pniej przez egzemplarze interfejsu IDoubleLink.
Public Interface IDoubleLink
    ' Reprezentuje albo poprzedni element na licie dwukierunkowej,
    ' do ktrej naley ten obiekt, albo nie reprezentuje niczego.
    Property Previous() As IDoubleLink
    ' Reprezentuje albo nastpny element na licie dwukierunkowej,
    ' do ktrej naley ten obiekt, albo nie reprezentuje niczego.
    Property [Next]() As IDoubleLink
End Interface 'IDoubleLink

' Klasa AbstractDoubleLink implementuje interfejs IDoubleLink.
Public MustInherit Class AbstractDoubleLink
    Implements IDoubleLink
    ' Reprezentuje albo poprzedni element na licie dwukierunkowej,
    ' do ktrej naley ten obiekt, albo nie reprezentuje niczego.
    Private myPrevious As IDoubleLink

    ' Reprezentuje albo nastpny element na licie dwukierunkowej,
    ' do ktrej naley ten obiekt, albo nie reprezentuje niczego.
    Private myNext As IDoubleLink

    ' Zwraca albo poprzedni element na licie dwukierunkowej,
    ' do ktrej naley ten obiekt, albo nie zwraca niczego.
    Public Property Previous() As IDoubleLink Implements IDoubleLink.Previous
        Get
            Return myPrevious
        End Get
        Set(ByVal value As IDoubleLink)
            myPrevious = value
        End Set
    End Property

    ' Zwraca albo nastpny element na licie dwukierunkowej,
    ' do ktrej naley ten obiekt, albo nie zwraca niczego.
    Public Property [Next]() As IDoubleLink Implements IDoubleLink.Next
        Get
            Return myNext
        End Get
        Set(ByVal value As IDoubleLink)
            myNext = value
        End Set
    End Property
End Class 'AbstractDoubleLink
